package gov.va.med.mhv.mrp.service.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.data.model.MyGoalsTasks;

@Component
public class MyGoalsTaskListConverter implements Converter<List<MyGoalsTasks>, List<MyGoalTaskDTO>> {
	
	@Autowired
	private MyGoalTaskConverter myGoalTaskConverter;

	@Override
	public List<MyGoalTaskDTO> convert(List<MyGoalsTasks> mygoalsTasks) {
		List<MyGoalTaskDTO> dtos = new ArrayList<MyGoalTaskDTO>();
		
		for (MyGoalsTasks mygoalTasks : mygoalsTasks) {	
			MyGoalTaskDTO dto = myGoalTaskConverter.convert(mygoalTasks);
			dtos.add(dto);
		}
		
		return dtos;
	}


}
